// eslint-disable-next-line @typescript-eslint/no-var-requires
const canonicalize = require('canonicalize')
import { sign } from 'tweetnacl'

export function createReqSignature(
  req: any,
  privateKey: Uint8Array,
): Uint8Array {
  const canonicalizedBody = canonicalize(req)
  const signature = sign.detached(
    new Uint8Array(Buffer.from(canonicalizedBody, 'utf-8')),
    privateKey,
  )

  return signature
}
